/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.reward;

import dev.toma.gunsrpg.common.quests.reward.IAssemblyFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public interface IQuestItemProvider {
    public int getWeight();

    public ItemStack[] assembleItem(PlayerEntity var1);

    public static class Impl
    implements IQuestItemProvider {
        private final Supplier<Item> itemSupplier;
        private final int count;
        private final int weight;
        private final IAssemblyFunction[] functions;

        public Impl(Supplier<Item> itemSupplier, int count, int weight, IAssemblyFunction[] functions) {
            this.itemSupplier = itemSupplier;
            this.count = count;
            this.weight = weight;
            this.functions = functions;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public ItemStack[] assembleItem(PlayerEntity player) {
            ItemStack stack = new ItemStack((IItemProvider)this.itemSupplier.get(), this.count);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (this.functions != null) {
                for (IAssemblyFunction function : this.functions) {
                    items.addAll(Arrays.asList(function.onAssembly(stack, player)));
                }
            }
            if (items.isEmpty()) {
                items.add(stack);
            }
            return items.toArray(new ItemStack[0]);
        }

        public int getCount() {
            return this.count;
        }

        public Item getItem() {
            return this.itemSupplier.get();
        }

        public int getFunctionCount() {
            return this.functions != null ? this.functions.length : 0;
        }
    }
}

